#!/bin/bash

#########################################################################
#                      FCOE Boot INITRD Creation			#
#########################################################################

#*********************** Start - Global Variables ***********************
# OS         => RedHat | SuSE  				(defualt=RedHat)
# VER        => 5 | 6 | 11			(default=5)
# UPGRADE    => 0 | 1 | 2 | 3 | 4 | 5			(default=5)
#

OS=RedHat
VER=0
UPGRADE=0
UPSTREAM=0
X64=
BNX2X=0
INITIATOR=0
DISTRO=" "
MOUNT=/mnt/fcoe
HOME=`pwd`

PARAMS=0
DEBUG=" "
SPEED=0
DUPLEX=" "
AUTONEG=" "
#************************** End - Global Variables **********************


#********************** Start - determine_OS function *******************
determine_OS ()	
{
 l_upgrade=0
 l_upgrade2=0
 
 if [ `cat /etc/issue | grep -i -c Red.Hat` -eq '1' ]; then	#Red Hat
   OS=RedHat
   RHV=`uname -r | cut -d - -f 1 | cut -d . -f 3`
   if [ $RHV -ge '32' ]; then	#Red Hat 6 or upstream kernel
     VER=6
   else
     echo "ERROR: Your Red Hat system is not version 6.0. Can not continue...exiting"
     exit
   fi 
   if [ $RHV -gt '32' ]; then
     UPSTREAM=1  #Upstream kernel version detected
   fi
   if [ $UPSTREAM -eq '0' ]; then
     KER_MINOR=`uname -r | cut -d . -f 3 | cut -d - -f 2`
     if [ $KER_MINOR -ge '112' ]; then
       UPSTREAM=1
     fi
   fi
 elif [ `cat /etc/issue | grep -i -c SuSE` -eq '1' ]; then	#SuSE
   OS=SuSE
   DISPLAY_ERROR=1
   if [ `uname -r | grep -i -c 2.6.27` -eq '1' ]; then     #SuSE 11 only
     VER=11
     UPGRADE=0
   else
     UPGRADE=4
   fi
   if [ `uname -r | grep -i -c 2.6.32` -eq '1' ]; then     #SuSE 11 SP1
     VER=11
     l_upgrade=`uname -r | cut -d . -f 4 | cut -d - -f 1` 
     l_upgrade2=`uname -r | cut -d - -f 2 | cut -d . -f 1`
     if [ \( $UPGRADE == '4' \) ]; then       
       if [ \( $l_upgrade -ge '3' \) ]; then   # Upgrade 1
         UPGRADE=1
       fi
     fi
     if [ -e /sbin/bnx2fcd ]; then
       UPSTREAM=0
     else
       ## Build INITRD as an UPSTREAM-style kernel
       UPSTREAM=1
     fi
     DISPLAY_ERROR=0
   fi
   if [ `uname -r | grep -i -c 3.0.4` -eq '1' ]; then     #SuSE 11 SP2
     VER=11
     UPGRADE=2
     DISPLAY_ERROR=0
     UPSTREAM=1
   fi
   if [ $DISPLAY_ERROR -eq '1' ]; then
     echo "ERROR: Your SuSE system is not version 11 SP1 or later. Can not continue"
     exit       
   fi
 else
     echo "ERROR: Unable to determine distribution via /etc/issue"
     echo "       Please, run this script on Red hat or SuSE distribution"
     exit
 fi
  
 DISTRO="$OS$VER$UPGRADE"

}	
#********************** End   - determine_OS function ********************



#********************** Start - determine_ARCH function ******************
determine_ARCH ()
{
 ARCH=`uname -i`

 if [ $ARCH == "x86_64" ]; then
   X64=64
 else
   X64=
 fi
}
#********************** End - determine_ARCH function **********************



#********************** Start - determine_NIC function *********************
determine_NIC ()
{
 BNX2X=`lsmod | grep -i -c -w bnx2x`
 if [ \( $BNX2X == '0' \) ]; then
   echo "ERROR: Unable to detect a supported network driver..."
   echo "       Load a supported network driver prior to executing this script."
   exit
 fi
}
#********************** End - determine_NIC function *************************



#******************* Start - determine_FCoE_PATH function *******************
determine_FCoE_PATH()
{
 if [ \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
   INITIATOR=1
   if [ \( $INITIATOR != '0' \) -a \( $INITIATOR != '1' \) ]; then
     echo " ERROR: Invalid input received....exiting"
     exit
   fi
 else
   echo "ERROR: Installed OS not supported"
   echo $OS$VER
   exit
 fi
}
#********************** End - determine_FCoE_PATH function *******************




#************************ Start - check_modules function ***********************
check_modules ()
{
  
  #................. Start - check_generic_modules function ....................
  check_generic_modules ()
  {
   echo
  }
  #................... End - check_generic_modules function ......................



  #.................... Start - check_offload_modules function ...................
  check_offload_modules()
  {
   ## This function is invoked with offload path only.

   if [ \( $OS$VER == 'SuSE11' \) -o \( $OS$VER == 'RedHat6' \) ]; then  ## OS is SuSE11
     if [ -e /lib/modules/`uname -r`/kernel/lib/libcrc32c.ko ]; then
       echo "libcrc32c.ko...............Found"
     else
       echo "ERROR: Module \"libcrc32c.ko\" not found...Exiting"
       exit
     fi

     if [ $OS$VER == 'SuSE11' ]; then
       if [ -e /lib/modules/`uname -r`/kernel/crypto/crc32c.ko ]; then
         echo "crc32c.ko..................Found"
       else
         echo "ERROR: Module \"crc32c.ko\" not found...Exiting"
         exit
       fi
     fi
 
     if [ -e /lib/modules/`uname -r`/kernel/drivers/net/mdio.ko ]; then
       echo "mdio.ko....................Found"
     else
       echo "ERROR: Module \"mdio.ko\" not found...Exiting"
       exit
     fi  
     if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
       echo "uio.ko.....................Found"
     else
       echo "ERROR: Module \"uio.ko\" not found...Exiting"
       exit
     fi
   fi

   if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_tgt.ko ]; then
     echo "scsi_tgt.ko................Found"
   else
     echo "ERROR: Module \"scsi_tgt.ko\" not found...Exiting"
     exit
   fi
   if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_fc.ko ]; then
     echo "scsi_transport_fc.ko.......Found"
   else
     echo "ERROR: Module \"scsi_transport_fc.ko\" not found...Exiting"
     exit
   fi

   if [ \( -e /lib/modules/`uname -r`/extras/cnic.ko \) -o \( -e /lib/modules/`uname -r`/updates/cnic.ko \) -o \( -e /lib/modules/`uname -r`/kernel/drivers/net/cnic.ko \) ]; then
     echo "cnic.ko....................Found"
   else
     echo "ERROR: Module \"cnic.ko\" not found...Exiting"
     exit
   fi

   if [ \( -e /lib/modules/`uname -r`/extras/bnx2fc.ko \) -o \( -e /lib/modules/`uname -r`/updates/bnx2fc.ko \) -o \( -e /lib/modules/`uname -r`/kernel/drivers/scsi/bnx2fc/bnx2fc.ko \) ]; then
     echo "bnx2fc.ko..................Found"
   else
     echo "ERROR: Module \"bnx2fc.ko\" not found...Exiting"
     exit
   fi

   if [ \( $UPSTREAM -eq '0' \) -o  \( \( $UPSTREAM -eq '1' \) -a \( $OS$VER == 'SuSE11' \) -a \( $UPGRADE -eq '1' \)  \) ]; then
     if [ \( -e /lib/modules/`uname -r`/extras/libfc2.ko \) -o \( -e /lib/modules/`uname -r`/updates/libfc2.ko \) ]; then
       echo "libfc2.ko..................Found"
     else
       echo "ERROR: Module \"libfc2.ko\" not found...Exiting"
       exit
     fi
     if [ \( -e /lib/modules/`uname -r`/extras/libfcoe2.ko \) -o \( -e /lib/modules/`uname -r`/updates/libfcoe2.ko \) ]; then
       echo "libfcoe2.ko................Found"
     else
       echo "ERROR: Module \"libfcoe2.ko\" not found...Exiting"
       exit
     fi
   else
     if [ \( -e /lib/modules/`uname -r`/kernel/drivers/scsi/libfc/libfc.ko \) ]; then
       echo "libfc.ko...................Found"
     else
       echo "ERROR: Module \"libfc.ko\" not found...Exiting"
       exit
     fi
     if [ \( -e /lib/modules/`uname -r`/kernel/drivers/scsi/fcoe/libfcoe.ko \) ]; then
       echo "libfcoe.ko.................Found"
     else
       echo "ERROR: Module \"libfcoe.ko\" not found...Exiting"
       exit
     fi
     if [ \( -e /lib/modules/`uname -r`/kernel/net/ipv6/ipv6.ko \) ]; then
       echo "ipv6.ko....................Found"
     else
       echo "ERROR: Module \"ipv6.ko\" not found...Exiting"
       exit
     fi
       
   fi
  }
  #....................... End - check_offload_modules function ..................



  #.................... Start - check_nonoffload_modules function .................
  check_nonoffload_modules ()  
  {
   echo
  }
  #.................... End - check_nonoffload_modules function .................

check_generic_modules

if [ \( $INITIATOR == '1' \) -a \( \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) \) ]; then
  check_offload_modules
elif [ \( $INITIATOR == '0' \) -a \( \( $OS == 'RedHat' \) -o \( $OS == 'SuSE' \) \) ]; then
  check_nonoffload_modules
else
  echo "ERROR: unidentified OS...exiting"
  exit
fi  

}
#*************************** End - check_modules function ***********************




#************************* Start - create_fcoe_script function ******************
create_fcoe_script ()
{
  
  #........................... Start - load_NIC_drivers function.......................
  load_NIC_drivers ()
    {
     # If Offload Path load bnx2 or bnx2x only
     if [  \( $INITIATOR == '1' \) -a \( \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) \) ]; then
       echo "#!/bin/bash " > fcoe_script
       if [ $BNX2X != '0' ]; then
           if [ $OS$VER == 'SuSE11' ]; then
             echo "echo \"Loading crc32c.ko module\"" >> fcoe_script
             echo "insmod /lib/crc32c.ko" >> fcoe_script
           fi
           echo "echo \"Loading libcrc32c.ko module\"" >> fcoe_script
           echo "insmod /lib/libcrc32c.ko" >> fcoe_script
           echo "echo \"Loading mdio.ko module\"" >> fcoe_script
           echo "insmod /lib/mdio.ko" >> fcoe_script
	   echo "echo \"Loading bnx2x.ko module\"" >> fcoe_script
           echo "insmod /lib/bnx2x.ko" >> fcoe_script
       fi

         echo "" >> fcoe_script
         echo "##Bring up all interfaces.  Only bnx2x driver should be loaded at this time" >> fcoe_script
         echo "TEMPLIST=\`ifconfig -a | grep eth | awk '{print \$1}'\`" >> fcoe_script
         echo "" >> fcoe_script
         echo "for i in \$TEMPLIST" >> fcoe_script
         echo "do" >> fcoe_script
         echo "ifconfig \$i up" >> fcoe_script
         echo "done" >> fcoe_script
         echo "sleep 5" >> fcoe_script
         echo "" >> fcoe_script
     fi
    }
  #............................ End - load_NIC_drivers function........................



  #......................... Start - load_generic_modules function.....................
  load_generic_modules ()
    {
     echo "" >> fcoe_script	

     echo "echo \"Loading llc.ko module\"" >> fcoe_script
     echo "insmod /lib/llc.ko" >> fcoe_script
     echo "echo \"Loading stp.ko module\"" >> fcoe_script
     echo "insmod /lib/stp.ko" >> fcoe_script
     echo "echo \"Loading garp.ko module\"" >> fcoe_script
     echo "insmod /lib/garp.ko" >> fcoe_script
     echo "echo \"Loading 8021q.ko module\"" >> fcoe_script
     echo "insmod /lib/8021q.ko" >> fcoe_script
     echo "" >> fcoe_script	
    }
  #............................. End - load_generic_modules function.........................


  #........................... Start - load_ offload_modules function .......................
  load_offload_modules ()
    {
     echo "echo \"Loading scsi_tgt.ko module\"" >> fcoe_script
     echo "insmod /lib/scsi_tgt.ko" >> fcoe_script
     echo "echo \"Loading scsi_transport_fc.ko module\"" >> fcoe_script
     echo "insmod /lib/scsi_transport_fc.ko" >> fcoe_script
     if [ \( $UPSTREAM -eq '0' \) -o \( \( $UPSTREAM -eq '1' \) -a \( $OS$VER == 'SuSE11' \) -a \( $UPGRADE -eq '1' \) \) ]; then
       echo "echo \"Loading libfc2.ko module\"" >> fcoe_script
       echo "insmod /lib/libfc2.ko" >> fcoe_script
       echo "echo \"Loading libfcoe2.ko module\"" >> fcoe_script
       echo "insmod /lib/libfcoe2.ko" >> fcoe_script
     else
       echo "echo \"Loading libfc.ko module\"" >> fcoe_script
       echo "insmod /lib/libfc.ko" >> fcoe_script
       echo "echo \"Loading libfcoe.ko module\"" >> fcoe_script
       echo "insmod /lib/libfcoe.ko" >> fcoe_script
     fi

     echo "" >> fcoe_script
     echo "echo \"Loading uio.ko module\"" >> fcoe_script
     echo "insmod /lib/uio.ko" >> fcoe_script
     if [ $UPSTREAM -eq '1' ]; then
       echo "echo \"Loading ipv6.ko module\"" >> fcoe_script
       echo "insmod /lib/ipv6.ko" >> fcoe_script
     fi
     echo "echo \"Loading cnic.ko module\"" >> fcoe_script
     echo "insmod /lib/cnic.ko" >> fcoe_script
     echo "echo \"Loading bnx2fc.ko module\"" >> fcoe_script
     echo "insmod /lib/bnx2fc.ko" >> fcoe_script
     echo "" >> fcoe_script
     if [ \( $OS$VER == 'SuSE11' \) -a \( $UPSTREAM -eq '1' \) ]; then
       echo "echo \"Loading af_packet.ko module\"" >> fcoe_script
       echo "insmod /lib/af_packet.ko" >> fcoe_script
       echo "" >> fcoe_script
     fi
     if [ $OS$VER == 'RedHat6' ]; then
       if [ $MULTIPATHD == 'dm' ]; then
         echo "echo \"Loading dm-multipath.ko module\"" >> fcoe_script
         echo "modprobe dm-multipath" >> fcoe_script
         echo "echo \"Loading dm-round-robin.ko module\"" >> fcoe_script
         echo "modprobe dm-round-robin" >> fcoe_script
       fi
     fi
     echo "sleep 6" >> fcoe_script
     echo "" >> fcoe_script

     echo "echo \"Starting FCoE daemon\"" >> fcoe_script
     if [ $UPSTREAM -eq '0' ]; then
       echo "/sbin/bnx2fcd -f &" >> fcoe_script
     else
       echo "/usr/sbin/fipvlan -s -c -a" >> fcoe_script
     fi
        
     echo "sleep 9" >> fcoe_script
     echo "" >> fcoe_script
     if [ $OS$VER == 'RedHat6' ]; then
       if [ $MULTIPATHD == 'dm' ]; then
         echo "echo \"Starting multipathd daemon\"" >> fcoe_script
         echo "/sbin/multipathd" >> fcoe_script
         echo "sleep 7" >> fcoe_script
  
         echo "## Run kpartx on devices found in /dev/mapper" >> fcoe_script
         echo "DEVMAPLIST=\`ls /dev/mapper\`" >> fcoe_script
         echo "" >> fcoe_script
         echo "for i in \$DEVMAPLIST" >> fcoe_script
         echo "do" >> fcoe_script
         echo "if [ \$i == 'control' ]; then" >> fcoe_script
         echo "  continue" >> fcoe_script
         echo "fi" >> fcoe_script
         echo "/sbin/kpartx -a /dev/mapper/\$i" >> fcoe_script
         echo "done" >> fcoe_script
         echo "sleep 5" >> fcoe_script
       fi
     fi
    }   
  #........................... End - load_ offload_modules function .......................


  #........................ Start - load_nonoffload_openfcoe function ....................
  load_nonoffload_openfcoe ()
    {  
      echo
    }
  #......................... End - load_nonoffload_openfcoe function .....................


load_NIC_drivers

load_generic_modules

if [ \( $INITIATOR == '1' \) -a \( \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) \) ]; then
  load_offload_modules
elif [ \( $INITIATOR == '0' \) -a \( \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) \) ]; then
  load_nonoffload_openfcoe
else
  echo "ERROR: unsupported OS...exiting"
  exit
fi  
}
#**************************** End - FCoE Script Creation function **********************



#*************************** Start - create_initrd_img function ***************************
create_initrd_img ()
{
  #.......................... Start - copy_common_files function ...........................
  copy_common_files ()
    {    
     # For RedHat6, run 'dracut' utility to create initrd-*.img
     if [ $OS$VER == 'RedHat6' ]; then
       if [ $BNX2X -ge '1' ]; then
         RH6BNX2X=bnx2x
       fi
       if [ $UPSTREAM -eq '1' ]; then
         FIPVLAN=/usr/sbin/fipvlan
         BRCM_DAEMON=
       else
         BRCM_DAEMON=/sbin/bnx2fcd
       fi
       if [ $MULTIPATHD == 'dm' ]; then
         MULTIPATH_MOD1=dm-mod
         MULTIPATH_MOD2=dm-multipath
         if [ -e /sbin/multipathd ]; then
           MULTIPATH_DAEMON=/sbin/multipathd
         fi
         if [ -e /sbin/kpartx ]; then
           MULTIPATH_KPARTX=/sbin/kpartx
         fi
   
       fi

       if [ $MULTIPATHD == 'powerpath' ]; then
         if [ -d /etc/opt/emcpower ]; then
           ADD_DRACUT=powerpath
           OMIT_DRACUT=
         else
           echo "Powerpath support not detected, using native multipath support"
           ADD_DRACUT=
           OMIT_DRACUT=powerpath
         fi
       fi
         
       if [ -e /boot/initramfs-`uname -r`.img ]; then
         mv /boot/initramfs-`uname -r`.img /boot/initramfs-`uname -r`.org
       fi
       dracut --add-drivers " $RH6BNX2X $MULTIPATH_MOD1 $MULTIPATH_MOD2 " --add " $ADD_DRACUT " --omit " $OMIT_DRACUT " --install "$MULTIPATH_DAEMON $MULTIPATH_KPARTX $BRCM_DAEMON /sbin/ifconfig /sbin/insmod /bin/bash /bin/awk $FIPVLAN " --force

         mv /boot/initramfs-`uname -r`.img /boot/brcm-initrd-`uname -r`.img
       if [ -e /boot/initramfs-`uname -r`.org ]; then
         mv /boot/initramfs-`uname -r`.org /boot/initramfs-`uname -r`.img
       fi
     fi
     # Create and prepare folder to hold the initrd image files
     UNAME=`uname -r`
     INIT=init
     if [ $OS$VER == 'SuSE11' ]; then
       INIT=run_all.sh
     fi
 
     if [ \( $OS$VER == 'SuSE11' \) ]; then
       LIST=`cat /etc/sysconfig/kernel | grep INITRD_MODULES | grep -v DOMU | awk '{gsub(/\INITRD_MODULES=/,""); print}' | awk '{gsub(/\"/,""); print}'`
       if [ $MULTIPATHD == 'powerpath' ]; then
         if [ -d /etc/opt/emcpower ]; then
           PP_ROOT=`ls /dev | grep emcpower | grep -m 1 '[0-9]'`
           if [ -z $PP_ROOT ]; then
             echo "ERROR: Unable to locate a valid emcpowerXX entry in /dev directory.  Please ensure an emcpowerXX partition is enumerated prior to executing this script."
             exit 1
           else
             SPECIFY_ROOT="-d /dev/$PP_ROOT"
           fi
         else
           echo "WARNING:  Unable to locate PowerPath support.  Including native multipath support instead."
           MULTIPATHD=dm
           MULTI_MOD=dm-multipath
         fi
       fi 
       # Build INITRD with multipath support
       mkinitrd -i /boot/brcm-initrd-$UNAME -k /boot/vmlinuz-$UNAME -f $MULTIPATHD -m "$LIST sd_mod $MULTI_MOD" $SPECIFY_ROOT &> /dev/null
       gzip -q -d < /boot/brcm-initrd-$UNAME > $HOME/initrd.img
       rm /boot/brcm-initrd-$UNAME
     else
       if [ \( $OS$VER == 'RedHat6' \) ]; then
         gzip -q -d < /boot/brcm-initrd-$UNAME.img > $HOME/initrd.img
         if [ -e /boot/brcm-initrd-`uname -r`.img ]; then
           rm -fr /boot/brcm-initrd-`uname -r`.img
         fi
       fi
     fi
  
     mkdir $MOUNT
     cd  $MOUNT
     cpio -idum < $HOME/initrd.img
     rm $HOME/initrd.img
     cd $HOME

     # Copy VLAN support modules
     cp /lib/modules/`uname -r`/kernel/net/8021q/8021q.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/net/802/stp.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/net/802/garp.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/net/llc/llc.ko $MOUNT/lib

     # Copy common utilties and modules
     if [ \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       cp /sbin/ifconfig $MOUNT/sbin
       if [ $OS$VER == 'SuSE11' ]; then
         cp /bin/gawk $MOUNT/bin
         cp /bin/awk $MOUNT/bin
       fi
     fi
     if [ $# -eq '4' ]; then
       if [ $1 == 'debug' ]; then
         if [ \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
           cp /sbin/ethtool $MOUNT/bin
         else
           cp /usr/sbin/ethtool $MOUNT/bin
         fi
       fi
     fi

     # Modify init/linuxrc file
     if [ $OS$VER == 'SuSE11' ]; then
       INSERTION_LINE=`cat $MOUNT/$INIT | grep -m 1 -n 11-usb.sh | awk '{print $1}' | awk '{gsub(/\:\[/,""); print}'`
     elif [ $OS$VER == 'RedHat6' ]; then
       INSERTION_LINE=`cat $MOUNT/$INIT | grep -n pre-trigger | grep source_all| awk '{print $1}' | awk '{gsub(/\:source_all/,""); print}'`
     else
       INSERTION_LINE=`cat $MOUNT/$INIT | grep -n sd_mod.ko | grep insmod | awk '{print $1}' | awk '{gsub(/\:insmod/,""); print}'`
     fi

     if [ $OS$VER == 'SuSE11' ]; then
       echo $INSERTION_LINE"i ./fcoe_script" > sed.cmd
     else
       echo $INSERTION_LINE"a ./fcoe_script" > sed.cmd
     fi

     sed -f sed.cmd $MOUNT/$INIT > $MOUNT/$INIT.mod

     rm sed.cmd

     rm $MOUNT/$INIT
     mv $MOUNT/$INIT.mod $MOUNT/$INIT

     if [ \( $OS$VER == 'SuSE11' \) -a \( $UPGRADE -eq '1' \) ]; then
       INSERTION_LINE=`cat $MOUNT/$INIT | grep -n 14-fcoe.sh | grep source | awk '{print $1}' | awk '{gsub(/\:source/,""); print $1}'`
       if [ -z $INSERTION_LINE ]; then
         echo
       else
         sed $INSERTION_LINE"d" $MOUNT/$INIT > $MOUNT/$INIT.mod
         rm $MOUNT/$INIT
         mv $MOUNT/$INIT.mod $MOUNT/$INIT
       fi
     fi
     

     chmod 755 $MOUNT/$INIT

     chmod 755 fcoe_script

     cp fcoe_script $MOUNT
     if [ $OS$VER == 'RedHat6' ]; then
       chmod 777 $MOUNT/fcoe_script
     fi
    }
  #........................... End - copy_common_files function ..........................


  #.......................... Start - copy_offload_files function.........................
  copy_offload_files ()
    {
     # Copy Adapter L2 Driver Files
     if [ $BNX2X != '0' ]; then
       if [ \( $OS$VER == 'SuSE11' \) ]; then
         cp /lib/modules/`uname -r`/kernel/crypto/crc32c.ko $MOUNT/lib
       fi
       cp /lib/modules/`uname -r`/kernel/lib/libcrc32c.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/drivers/net/mdio.ko $MOUNT/lib

       if [ -e /lib/modules/`uname -r`/extras/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/extras/bnx2x.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/updates/bnx2x.ko $MOUNT/lib;
       else
         if [ -e /lib/modules/`uname -r`/kernel/drivers/net/bnx2x.ko ]; then
           cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x.ko $MOUNT/lib
         fi
         if [ $UPSTREAM -eq '1' ]; then
           if [ $OS$VER == 'RedHat6' ]; then
             if [ -e /lib/modules/`uname -r`/kernel/drivers/net/bnx2x/bnx2x.ko ]; then
               cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x/bnx2x.ko $MOUNT/lib
             fi
             cp -r /lib/firmware/bnx2x $MOUNT/lib/firmware
             cp /lib/firmware/bnx2x/* $MOUNT/lib/
           fi
         fi
         if [ \( $OS$VER == 'SuSE11' \) ]; then
           if [ $UPGRADE -eq '2' ]; then
             if [ -e /lib/modules/`uname -r`/kernel/drivers/net/bnx2x/bnx2x.ko ]; then
               cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x/bnx2x.ko $MOUNT/lib
             fi
             cp -r /lib/firmware/bnx2x $MOUNT/lib/firmware
             cp /lib/firmware/bnx2x/* $MOUNT/lib/
           else
           cp /lib/firmware/`uname -r`/bnx2x* $MOUNT/lib/firmware
           fi
         fi
       fi
     fi

     # Copy Open-Fcoe and Support Modules Files
     cp /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko $MOUNT/lib


     cp /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_fc.ko $MOUNT/lib
     cp /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_tgt.ko $MOUNT/lib

     if [ -e /lib/modules/`uname -r`/extras/cnic.ko ]; then
       cp /lib/modules/`uname -r`/extras/cnic.ko $MOUNT/lib;
     elif [ -e /lib/modules/`uname -r`/updates/cnic.ko ]; then
       cp /lib/modules/`uname -r`/updates/cnic.ko $MOUNT/lib;
     else
       cp /lib/modules/`uname -r`/kernel/drivers/net/cnic.ko $MOUNT/lib
     fi

     if [ -e /lib/modules/`uname -r`/extras/bnx2fc.ko ]; then
       cp /lib/modules/`uname -r`/extras/bnx2fc.ko $MOUNT/lib;
     elif [ -e /lib/modules/`uname -r`/updates/bnx2fc.ko ]; then
       cp /lib/modules/`uname -r`/updates/bnx2fc.ko $MOUNT/lib;
     else
       cp /lib/modules/`uname -r`/kernel/drivers/scsi/bnx2fc/bnx2fc.ko $MOUNT/lib;
     fi

     if [ \( $UPSTREAM -eq '0' \) -o \( \( $UPSTREAM -eq '1' \) -a \( $OS$VER == 'SuSE11' \)  -a \( $UPGRADE -eq '1' \) \) ]; then
       if [ -e /lib/modules/`uname -r`/extras/libfc2.ko ]; then
         cp /lib/modules/`uname -r`/extras/libfc2.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/libfc2.ko ]; then
         cp /lib/modules/`uname -r`/updates/libfc2.ko $MOUNT/lib;
       fi

       if [ -e /lib/modules/`uname -r`/extras/libfcoe2.ko ]; then
         cp /lib/modules/`uname -r`/extras/libfcoe2.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/libfcoe2.ko ]; then
         cp /lib/modules/`uname -r`/updates/libfcoe2.ko $MOUNT/lib;
       fi
     else
       cp /lib/modules/`uname -r`/kernel/drivers/scsi/libfc/libfc.ko $MOUNT/lib;
       cp /lib/modules/`uname -r`/kernel/drivers/scsi/fcoe/libfcoe.ko $MOUNT/lib;
       cp /lib/modules/`uname -r`/kernel/net/ipv6/ipv6.ko $MOUNT/lib;
     fi

     if [ \( $OS$VER == 'SuSE11' \) -a \( $UPSTREAM -eq '1' \) ]; then
       cp /lib/modules/`uname -r`/kernel/net/ipv6/ipv6.ko $MOUNT/lib;
       cp /lib/modules/`uname -r`/kernel/net/packet/af_packet.ko $MOUNT/lib;
     fi
       
  
     if [ $UPSTREAM == '0' ]; then
       cp /sbin/bnx2fcd $MOUNT/sbin
     else
       mkdir -p $MOUNT/usr/sbin
       cp /usr/sbin/fipvlan $MOUNT/usr/sbin
     fi
     if [ $MULTIPATHD == 'dm' ]; then
       if [ -e /etc/multipath.conf ]; then
         cp /etc/multipath.conf $MOUNT/etc
       fi
     fi
    }
  #.......................... End - copy_offload_files function ..........................
  


  #................... Start - copy_nonoffload_openfcoe_files function ...................
  copy_nonoffload_openfcoe_files ()
    {
     if [ $BNX2X != '0' ]; then
       if [ -e /lib/modules/`uname -r`/extras/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/extras/bnx2x.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/updates/bnx2x.ko $MOUNT/lib;
       else
         cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x.ko $MOUNT/lib
         if [ \( $OS$VER == 'SuSE11' \) ]; then
           cp /lib/firmware/`uname -r`/bnx2x* $MOUNT/lib/firmware
         fi
       fi
     fi

    }
  #...................... End - copy_nonoffload_openfcoe_files function ...................

copy_common_files

if [ \( $INITIATOR == '1' \) -a \( \( "$OS$VER" == 'RedHat6' \) -o \( "$OS$VER" == 'SuSE11' \) \) ]; then
  copy_offload_files
elif [ \( $INITIATOR == '0' \) -a \( \( "$OS$VER" == 'RedHat6' \) -o \( "$OS$VER" == 'SuSE11' \) \) ]; then
  copy_nonoffload_openfcoe_files
else
  echo "ERROR: OS version is not supported or initiator is not known ...exiting"
  exit
fi
if [ $OS$VER == 'SuSE11' ];then
  cp /etc/modprobe.d/unsupported-modules $MOUNT/etc/modprobe.d/unsupported-modules
fi 

if [ $UPSTREAM -eq '1' ]; then
  mkdir -p $MOUNT/etc/fcoe
  mkdir -p $MOUNT/var/lib/lldpad
  mkdir -p $MOUNT/var/run/lldpad
  mkdir -p $MOUNT/var/lock/subsys
  if [ $OS$VER == 'SuSE11' ]; then
    cp /sbin/lldpad $MOUNT/sbin/lldpad
  fi
  if [ $OS$VER == 'RedHat6' ]; then
    cp /var/lib/lldpad/lldpad.conf $MOUNT/var/lib/lldpad
  fi
fi
if [ $OS$VER == 'RedHat6' ]; then
  cp -r /lib$X64/multipath $MOUNT/lib$X64
  CUR_PWD=`pwd`
  cd $MOUNT/lib$X64
  if [ -e libaio.so.1 ]; then
    sleep 1
  else
    cp /lib$X64/libaio.so.1.0.1 .
    ln -s ./libaio.so.1.0.1 libaio.so.1
  fi
  cd $CUR_PWD

fi
}
#******************************** End - create_initrd_img **********************************

#********************** Start - usage() function ******************
usage ()
{
 echo "Copyright (C) 2014 QLogic Corporation"
 echo
 echo " Usage: ./fcoe_setup.sh [Options]"
 echo
 echo "  Options are as below:"
 echo
 echo "  -f powerpath           Add PowerPath support in INITRD."
 echo "                         By default native multipath support is included."
 echo
 echo "  -h                     Print help message"
 echo
 exit 0
}
#********************** End - usage() function **********************

################################# Start - Main Program #####################################

# Clear the screen
 clear
 echo "Creating QLogic FCoE INITRD"

# By default include native multipath support
 MULTIPATHD=dm
 MULTI_MOD=dm-multipath
 if [ $# -gt 0 ]; then
   if [ $1 == '-f' ]; then
     if [ -n $2 ]; then
       if [ $2 == 'powerpath' ]; then
         MULTIPATHD=powerpath
         MULTI_MOD=
       fi
     fi
   fi
   if [ $1 == '-h' ]; then
     usage
   fi
   if [ $# -eq 4 ]; then
     PARAMS=4
     DEBUG=$1
     SPEED=$2
     DUPLEX=$3
     AUTONEG=$4
   fi
 fi

# Determine what Operation System is running (Red Hat or SuSE)
 determine_OS

# Determine architecture of you system (x32 vs x64)
 determine_ARCH

# Determine what driver is loaded (bnx2, bnx2x or both)
 determine_NIC

# Determine whether offload or non-offload
 determine_FCoE_PATH

# Check all required modules
 check_modules

# Create fcoe script
 create_fcoe_script

# Create initrd image for fcoe boot
 create_initrd_img

# Start- Zip the image
 cd $MOUNT
 find . | cpio --create --format='newc' > $HOME/initrd.img
 cd $HOME
 gzip -c < $HOME/initrd.img > $HOME/fcoe-initrd.img
 rm $HOME/initrd.img
 rm $HOME/fcoe_script
 rm -fr $MOUNT
# End- Zip the image

################################### End - Main Program ###################################
